/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.peconnection;

import filenet.pe.ceutils.ConnectionPoint;
import filenet.vw.apps.taskman.pa.peconnection.ConnectionPointWrapper;
import filenet.vw.apps.taskman.pa.peconnection.IPEConnection;
import filenet.vw.apps.taskman.pa.peconnection.PEExposedLogField;
import filenet.vw.apps.taskman.pa.peconnection.PEExposedLogFields;
import filenet.vw.base.VWDebug;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class PEConnectionImpl
implements IPEConnection {
    private ClassLoader m_classLoader = null;
    private Object m_session = null;
    private int m_region = -1;
    private String m_serverName = null;

    protected PEConnectionImpl(ClassLoader classLoader) {
        this.m_classLoader = classLoader;
    }

    public boolean isConnected() {
        return this.m_session != null;
    }

    public ConnectionPoint[] getConnectionPoints(String ceURL, String user, String password) throws Exception {
        ConnectionPoint[] result = null;
        try {
            Class<?> connectionPoints = this.m_classLoader.loadClass("filenet.pe.ceutils.ConnectionPoints");
            Class[] paramTypes = new Class[]{String.class, String.class, String.class};
            Object[] args = new Object[]{ceURL, user, password};
            Object[] cps = (Object[])connectionPoints.getMethod("GetConnectionPoints", paramTypes).invoke(connectionPoints, args);
            result = ConnectionPointWrapper.copy(cps);
        }
        catch (Exception e) {
            this.throwException(e);
        }
        return result;
    }

    public void connect(String ceURL, String user, String password, String connectionPoint) throws Exception {
        if (this.m_session != null) {
            throw new IllegalStateException("Already connected.");
        }
        try {
            this.m_session = this.m_classLoader.loadClass("filenet.vw.api.VWSession").newInstance();
            Class[] paramTypes = new Class[]{String.class};
            Object[] args = new Object[]{ceURL};
            Method setBootstrapCEURI = this.m_session.getClass().getMethod("setBootstrapCEURI", paramTypes);
            setBootstrapCEURI.invoke(this.m_session, args);
            paramTypes = new Class[]{String.class, String.class, String.class};
            args = new Object[]{user, password, connectionPoint};
            Method logon = this.m_session.getClass().getMethod("logon", paramTypes);
            logon.invoke(this.m_session, args);
            this.m_region = (Integer)this.m_session.getClass().getMethod("getIsolatedRegion", null).invoke(this.m_session, null);
            this.m_serverName = (String)this.m_session.getClass().getMethod("getServerName", null).invoke(this.m_session, null);
        }
        catch (Exception e) {
            this.m_session = null;
            this.throwException(e);
        }
    }

    public void disconnect() {
        try {
            Method logoff = this.m_session.getClass().getMethod("logoff", null);
            logoff.invoke(this.m_session, null);
            this.m_region = -1;
            this.m_serverName = null;
        }
        catch (Exception e) {
            VWDebug.logException(e, "Exception while doing VWSession.logoff().");
        }
        this.m_session = null;
    }

    public PEExposedLogFields getLogFields(HashMap logNames) throws Exception {
        PEExposedLogFields fields = null;
        try {
            fields = new PEExposedLogFields();
            Method fetchEventLogNames = this.m_session.getClass().getMethod("fetchEventLogNames", null);
            String[] eventLogNames = (String[])fetchEventLogNames.invoke(this.m_session, null);
            for (int i = 0; i < eventLogNames.length; ++i) {
                if (logNames != null && !logNames.containsKey(eventLogNames[i]) && !logNames.containsKey(eventLogNames[i].toUpperCase())) continue;
                Method fetchEventLog = this.m_session.getClass().getMethod("fetchEventLog", String.class);
                Object log = fetchEventLog.invoke(this.m_session, eventLogNames[i]);
                Object logDef = log.getClass().getMethod("fetchLogDefinition", null).invoke(log, null);
                Object[] fieldDefs = (Object[])logDef.getClass().getMethod("getFields", null).invoke(logDef, null);
                if (fieldDefs == null) continue;
                for (int j = 0; j < fieldDefs.length; ++j) {
                    Object fieldDef = fieldDefs[j];
                    int fieldType = (Integer)fieldDef.getClass().getMethod("getFieldType", null).invoke(fieldDef, null);
                    if (fieldType == 256) {
                        fieldType = 16;
                    }
                    if ((fieldType & 0x1F) == 0) continue;
                    String name = (String)fieldDef.getClass().getMethod("getName", null).invoke(fieldDef, null);
                    Integer length = (Integer)fieldDef.getClass().getMethod("getLength", null).invoke(fieldDef, null);
                    Boolean system = (Boolean)fieldDef.getClass().getMethod("isSystemField", null).invoke(fieldDef, null);
                    PEExposedLogField field = new PEExposedLogField(name, fieldType, length, system);
                    fields.add(field);
                }
            }
        }
        catch (InvocationTargetException ex) {
            this.throwException(ex);
        }
        return fields;
    }

    public String getServerName() {
        return this.m_serverName;
    }

    public int getIsolatedRegion() {
        return this.m_region;
    }

    private void throwException(Exception ex) throws Exception {
        Throwable target;
        if (ex instanceof InvocationTargetException && (target = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
            throw (Exception)target;
        }
        throw ex;
    }
}

